local screenAddress = "16d7bd7e-e034-4b8e-8fb6-61d7a362edd4"

local component = require("component")

local screen = component.proxy(screenAddress)
local screenGpu

print("[" .. screen.type .. "] " .. screen.address)

for address, name in component.list("gpu", true) do
  local gpu = component.proxy(address)

  local isAvailable = gpu.getScreen()
  if isAvailable == nil then
    local successful = gpu.bind(screenAddress, true)
    
    if successful then
      print("Bound screen ("..screenAddress..") to gpu ("..address..")")
    end
  end

  if address ~= component.gpu then
    screenGpu = component.proxy(address)
  end

end

if screenGpu == nil then
  error("No screen or gpu detected")
end

local vW, vH = screen.getAspectRatio()
print(vW, vH)

local mW, mH = screenGpu.maxResolution()
screenGpu.setResolution(mW, mH)

local w, h = screenGpu.getResolution()
screenGpu.fill(1, 1, w, h, " ")

screenGpu.setForeground(0x000000)
screenGpu.setBackground(0xFFFFFF)
screenGpu.fill(1, 1, w, 10, " ")

screenGpu.set(w/2, h/2, "Laboratory")